﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;

namespace VIRP
{
    public static class LINQExtensions
    {
        //TLB.Fortify
        /// <summary>
        /// extension to find an entity or create one if none found 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="table"></param>
        /// <param name="find"></param>
        /// <param name="create"></param>
        /// <returns></returns>
        //public static T FindOrCreate<T>(this EntitySet<T> table, Func<T, bool> find, Action<T> create) where T : class, new()
        //{
        //    T val = table.FirstOrDefault(find);
        //    if (val == null)
        //    {
        //        val = new T();
        //        create(val);
        //        //table.InsertOnSubmit(val);
        //    }
        //    return val;
        //}

        //TLB.Fortify
        //public static T FindOrCreate<T>(this EntitySet<T> table, Func<T, bool> find) where T : class, new()
        //{
        //    return FindOrCreate(table, find, a => { });
        //} 

        public static IQueryable<T> PatientLike<T>(this IQueryable<T> data, string propertyOrFieldName, string value)
        {
            //string fieldSearch = "LAST_NAME";

            var param = Expression.Parameter(typeof(T), "PATIENT");

            // e => e.WKF_CASE.PATIENT.LAST_NAME.Contains()
            var name = Expression.PropertyOrField(Expression.PropertyOrField(Expression.PropertyOrField(param, "WKF_CASE"), "PATIENT"), propertyOrFieldName);
            var search = Expression.Constant(value, typeof(string));

            var body = Expression.Call(name, "Contains", null, search);

            Expression<Func<T, bool>> lambda;
            if (String.IsNullOrEmpty(value))
            {
                lambda = x => true;
            }
            else
            {
                lambda = Expression.Lambda<Func<T, bool>>(body, param);
            }

            return data.Where(lambda);
        }
        /// <summary>
        /// extension method converts list to a list of key-value pairs for dropdown binding
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="enumeration">Original list</param>
        /// <returns>Key-Value pair list</returns
        public static IEnumerable<KeyValuePair<int, T>> AsIndexed<T>(this IEnumerable<T> enumeration)
        {
            // Check to see that enumeration is not null    
            if (enumeration == null)
                throw new ArgumentNullException("enumeration");
            int i = 0;
            foreach (var item in enumeration)
            {
                yield return new KeyValuePair<int, T>(i++, item);
            }
        }

        /// <summary>
        /// Checks whether the source is in a list.
        /// </summary>
        /// <typeparam name="T">The type of node being traversed by the query.</typeparam>
        /// <param name="source">The item to check.</param>
        /// <param name="values">The values to check against.</param>
        /// <returns>true if the item is in the list; otherwise, false.</returns>
        public static bool In<T>(this T source, params T[] values) where T : IEquatable<T>
        {
            if (values == null)
                throw new ArgumentNullException("values");

            return In(source, ((IEnumerable<T>)values));
        }

        /// <summary>
        /// Checks whether the source is in a subquery.
        /// </summary>
        /// <typeparam name="T">The type of node being traversed by the query.</typeparam>
        /// <param name="source">The item to check.</param>
        /// <param name="values">The resultset from the subquery to check against.</param>
        /// <returns>true if the item is in the subquery's result; otherwise, false.</returns>
        public static bool In<T>(this T source, IEnumerable<T> values) where T : IEquatable<T>
        {
            if (source == null)
                throw new ArgumentNullException("source");

            if (values == null)
                throw new ArgumentNullException("values");

            foreach (T listValue in values)
            {
                if (listValue != null && source.Equals(listValue))
                    return true;
            }

            return false;
        }

        /// <summary>
        /// Order By extension that works for IEnumerables just like dynamic linq for IQueryables 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="input">IEnumerable to order by</param>
        /// <param name="queryString"></param>
        /// <returns></returns>
        public static IEnumerable<T> OrderBy<T>(this IEnumerable<T> input, string queryString)
        {
            if (string.IsNullOrEmpty(queryString))
                return input;

            int i = 0;
            foreach (string propname in queryString.Split(','))
            {
                var subContent = propname.Split(' ');
                if (subContent.Length == 1)
                {
                    if (i == 0)
                        input = input.OrderBy(x => GetPropertyValue(x, subContent[0].Trim()));
                    else
                        input = ((IOrderedEnumerable<T>)input).ThenBy(x => GetPropertyValue(x, subContent[0].Trim()));
                }
                else
                {
                    if (i == 0)
                        input = input.OrderByDescending(x => GetPropertyValue(x, subContent[0].Trim()));
                    else
                        input = ((IOrderedEnumerable<T>)input).ThenByDescending(x => GetPropertyValue(x, subContent[0].Trim()));
                }
                i++;
            }

            return input;
        }

        private static object GetPropertyValue(object obj, string property)
        {
            System.Reflection.PropertyInfo propertyInfo = obj.GetType().GetProperty(property);
            return propertyInfo.GetValue(obj, null);
        }
    }
}
